import Providers from "@/components/Provider";
import { Toaster } from "@/components/ui/toaster";
import Image from "next/image";
import Logo from "/public/logo-small.png";
export default function ForgetPasswordLayout({
  children, // will be a page or nested layout
}: {
  children: React.ReactNode;
}) {
  return (
    <main className="bg-gradient-to-b from-[#3A74FA] to-[#1D3A7D] h-[100vh] space-y-10 ">
      <div className="flex justify-center ">
        <Image src={Logo} alt="" className="mt-20" />
      </div>
      <main className="">
        <Providers>{children}</Providers>
        <Toaster />
      </main>
    </main>
  );
}
