"use client";
import { zodResolver } from "@hookform/resolvers/zod";
import { useForm } from "react-hook-form";
import { z } from "zod";

import { Button } from "@/components/ui/button";
import {
  Form,
  FormControl,
  FormDescription,
  FormField,
  FormItem,
  FormLabel,
  FormMessage,
} from "@/components/ui/form";
import { Input } from "@/components/ui/input";
import { toast } from "@/components/ui/use-toast";
import { URL } from "@/config/config";
import { forgetPassword, loginAPI } from "@/services/admin-service";
import { useRouter } from "next/navigation";
import Link from "next/link";

const FormSchema = z.object({
  email: z.string().email({
    message: "Please enter a valid email address.",
  }),
});

const ForgotPasswordPage = () => {
  const router = useRouter();
  const form = useForm<z.infer<typeof FormSchema>>({
    resolver: zodResolver(FormSchema),
    defaultValues: {
      email: "cityAdmin@yopmail.com",
    },
  });

  async function onSubmit(data: z.infer<typeof FormSchema>) {
    console.log("res");
    console.log(data.email);
    const reqserver: { status: string; message: string } = await forgetPassword(
      data.email
    );
    console.log(reqserver);
    toast({
      title: reqserver.message,
    });
    if (reqserver.status) {
      router.push("/forgot-password-otp");
    }
  }

  return (
    <div className="flex items-center">
      <div className="mx-auto max-w-md space-y-6">
        <div className="space-y-2 text-center">
          <h1 className="text-3xl font-bold text-white">Forgot Password</h1>
          <p className="text-white/80">
            Enter your email address and we{"'"}ll send you a link to reset your
            password.
          </p>
        </div>
        <div className="flex justify-center">
          <Form {...form}>
            <form
              onSubmit={form.handleSubmit(onSubmit)}
              className="w-2/3 space-y-6"
            >
              {" "}
              <FormField
                control={form.control}
                name="email"
                render={({ field }) => (
                  <FormItem>
                    <FormLabel className="text-white">Email</FormLabel>
                    <FormControl>
                      <Input placeholder="Enter Your Email" {...field} />
                    </FormControl>
                    <FormMessage />
                  </FormItem>
                )}
              />
              <div className="flex justify-center">
                <Button type="submit" variant="appdefault" className="w-full">
                  Reset Password
                </Button>
              </div>
            </form>{" "}
          </Form>
        </div>
      </div>
    </div>
  );
};

export default ForgotPasswordPage;
