"use client";

import { Button } from "@/components/ui/button";
import { Dialog, DialogContent, DialogTrigger } from "@/components/ui/dialog";
import { URL } from "@/config/config";
import { ColumnDef, useReactTable } from "@tanstack/react-table";
import { ArrowUpDown } from "lucide-react";

// This type is used to define the shape of our data.
// You can use a Zod schema here if you want.
// export type Payment = {
//   id: string;
//   amount: number;
//   status: "pending" | "processing" | "success" | "failed";
//   email: string;
// };
export type Payment = {
  _id: string;
  email: string;
  userType: string;
  image: string;
  firstName: string;
  lastName: string;
};

export const columns: ColumnDef<Payment>[] = [
  {
    accessorKey: "Serial Number",
    header: "Serial Number",
    cell: ({ row }) => {
      // Get the index of the row and add 1 to start from 1 instead of 0
      const serialNumber = row.index + 1;
      return <span>{serialNumber}</span>;
    },
  },
  {
    accessorKey: "image",
    header: "Image",
    cell: ({ row }) => (
      <div className="">
        {row.getValue("image") ? (
          // <img
          //   width={20}
          //   height={20}
          //   src={URL + "/" + row.getValue("image")}
          //   alt="-"
          // />
          <Dialog>
            <DialogTrigger asChild>
              <Button size="icon" variant="ghost" className="rounded-full">
                <img
                  width={20}
                  height={20}
                  src={URL + "/" + row.getValue("image")}
                  alt="-"
                />
              </Button>
            </DialogTrigger>
            <DialogContent className="flex justify-center">
              <img src={URL + "/" + row.getValue("image")} alt="-" />
            </DialogContent>
          </Dialog>
        ) : (
          <p>N/A</p>
        )}
      </div>
    ),
  },
  {
    accessorKey: "firstName",
    header: "First Name",
  },
  {
    accessorKey: "lastName",
    header: "Last Name",
  },
  {
    accessorKey: "email",
    header: ({ column }) => {
      return (
        // <Button
        //   variant="ghost"
        //   onClick={() => column.toggleSorting(column.getIsSorted() === "asc")}
        // >
        <h1>Email</h1>
        // <ArrowUpDown className="ml-2 h-4 w-4" />
        // </Button>
      );
    },
    cell: ({ row }) => <div className="lowercase">{row.getValue("email")}</div>,
  },
];
