"use client";

import { Button } from "@/components/ui/button";
import { Dialog, DialogContent, DialogTrigger } from "@/components/ui/dialog";
import { URL } from "@/config/config";
import { ColumnDef, useReactTable } from "@tanstack/react-table";
import { ArrowUpDown } from "lucide-react";

// This type is used to define the shape of our data.
// You can use a Zod schema here if you want.
// export type Payment = {
//   id: string;
//   amount: number;
//   status: "pending" | "processing" | "success" | "failed";
//   email: string;
// };

export type Payment = {
  _id: string;
  status: string;
  distance: string;
  from: {
    address: string;
  };
  destination: {
    address: string;
  };
  estFare: string;
  createdAt: string;
  driverImage: string;
  userImage: string;
  driverFirstName: string;
  waitingTime: string;
  rideEndTime: string;
  arrivalTime: string;
  totalTime: string;
  userFirstName: string;
};

export const columns: ColumnDef<Payment>[] = [
  {
    accessorKey: "Serial Number",
    header: "Serial Number",
    cell: ({ row }) => {
      // Get the index of the row and add 1 to start from 1 instead of 0
      const serialNumber = row.index + 1;
      return <span>{serialNumber}</span>;
    },
  },
  {
    accessorKey: "userFirstName",
    header: "User Name",
    cell: ({ row }) => <span>{row.original.userFirstName}</span>,
  },
  {
    accessorKey: "driverFirstName",
    header: "Rider Name",
    cell: ({ row }) => <span>{row.original.driverFirstName}</span>,
  },
  // {
  //   accessorKey: "status",
  //   header: "Status",
  //   cell: ({ row }) => <span>{row.original.status}</span>,
  // },

  {
    accessorKey: "from",
    header: "From Address",
    cell: ({ row }) => <span>{row.original.from.address}</span>,
  },
  {
    accessorKey: "destination",
    header: "Destination Address",
    cell: ({ row }) => <span>{row.original.destination.address}</span>,
  },
  {
    accessorKey: "distance",
    header: "Distance",
    cell: ({ row }) => <span>{row.original.distance}</span>,
  },
  {
    accessorKey: "estFare",
    header: "Fare",
    cell: ({ row }) => <span>{row.original.estFare}</span>,
  },
  {
    accessorKey: "createdAt",
    header: "Created At",
    cell: ({ row }) => {
      const createdAtDate = new Date(row.original.createdAt);
      return <span>{createdAtDate.toLocaleString()}</span>;
    },
  },
  // {
  //   accessorKey: "driverImage",
  //   header: "Driver Image",
  //   cell: ({ row }) => (
  //     <div className="">
  //       {row.original.driverImage ? (
  //         // <img
  //         //   width={20}
  //         //   height={20}
  //         //   src={URL + "/" + row.original.driverImage}
  //         //   alt="-"
  //         // />
  //         <Dialog>
  //           <DialogTrigger asChild>
  //             <Button size="icon" variant="ghost" className="rounded-full">
  //               <img
  //                 width={20}
  //                 height={20}
  //                 src={URL + "/" + row.original.driverImage}
  //                 alt="-"
  //               />
  //             </Button>
  //           </DialogTrigger>
  //           <DialogContent className="flex justify-center">
  //             <img src={URL + "/" + row.original.driverImage} alt="-" />
  //           </DialogContent>
  //         </Dialog>
  //       ) : (
  //         <p>N/A</p>
  //       )}
  //     </div>
  //   ),
  // },
  // {
  //   accessorKey: "userImage",
  //   header: "User Image",
  //   cell: ({ row }) => (
  //     <div className="">
  //       {row.original.userImage ? (
  //         <Dialog>
  //           <DialogTrigger asChild>
  //             <Button size="icon" variant="ghost" className="rounded-full">
  //               <img
  //                 width={20}
  //                 height={20}
  //                 src={URL + "/" + row.original.userImage}
  //                 alt="-"
  //               />
  //             </Button>
  //           </DialogTrigger>
  //           <DialogContent className="flex justify-center">
  //             <img src={URL + "/" + row.original.userImage} alt="-" />
  //           </DialogContent>
  //         </Dialog>
  //       ) : (
  //         <p>N/A</p>
  //       )}
  //     </div>
  //   ),
  // },

  {
    accessorKey: "waitingTime",
    header: "Waiting Time",
    cell: ({ row }) => <span>{row.original.waitingTime}</span>,
  },
  {
    accessorKey: "rideEndTime",
    header: "Ride End Time",
    cell: ({ row }: { row: any }) => {
      const originalDate: Date = new Date(row.original.rideEndTime);
      const options: Intl.DateTimeFormatOptions = {
        month: "numeric",
        day: "2-digit",
        year: "numeric",
        hour: "2-digit",
        minute: "2-digit",
        second: "2-digit",
        hour12: true,
      };
      const formattedDate: string = originalDate.toLocaleString(
        "en-US",
        options
      );
      return <span>{formattedDate}</span>;
    },
  },

  // {
  //   accessorKey: "arrivalTime",
  //   header: "Arrival Time",
  //   cell: ({ row }) => <span>{row.original.arrivalTime}</span>,
  // },
  // {
  //   accessorKey: "totalTime",
  //   header: "Total Time",
  //   cell: ({ row }) => <span>{row.original.totalTime}</span>,
  // },
];
