"use client";

import { Button } from "@/components/ui/button";
import { Dialog, DialogContent, DialogTrigger } from "@/components/ui/dialog";
import { URL } from "@/config/config";
import { ColumnDef, useReactTable } from "@tanstack/react-table";
import { ArrowUpDown } from "lucide-react";

// This type is used to define the shape of our data.
// You can use a Zod schema here if you want.
// export type Payment = {
//   id: string;
//   amount: number;
//   status: "pending" | "processing" | "success" | "failed";
//   email: string;
// };

export type Payment = {
  _id: string;
  status: string;
  distance: string;
  from: {
    address: string;
  };
  destination: {
    address: string;
  };
  estFare: string;
  createdAt: string;
  rejectedByImage: string;
  rejectedByFirstName: string;
};

export const columns: ColumnDef<Payment>[] = [
  {
    accessorKey: "Serial Number",
    header: "Serial Number",
    cell: ({ row }) => {
      // Get the index of the row and add 1 to start from 1 instead of 0
      const serialNumber = row.index + 1;
      return <span>{serialNumber}</span>;
    },
  },
  {
    accessorKey: "rejectedByImage",
    header: "Rejected By Image",
    cell: ({ row }) => (
      <div className="">
        {row.original.rejectedByImage ? (
          <Dialog>
            <DialogTrigger asChild>
              <Button size="icon" variant="ghost" className="rounded-full">
                <img
                  width={20}
                  height={20}
                  src={URL + "/" + row.original.rejectedByImage}
                  alt="-"
                />
              </Button>
            </DialogTrigger>
            <DialogContent className="flex justify-center">
              <img src={URL + "/" + row.original.rejectedByImage} alt="-" />
              {/* {row.getValue("idCard") ? (
              <img src={URL + "/" + row.getValue("idCard")} alt="-" />
            ) : (
              <p>N/A</p>
            )}
            {row.original.image ? (
              <img src={URL + "/" + row.original.image} alt="-" />
            ) : (
              <p>N/A</p>
            )} */}
            </DialogContent>
          </Dialog>
        ) : (
          <p>N/A</p>
        )}
      </div>
    ),
  },
  {
    accessorKey: "rejectedByFirstName",
    header: "Rejected By Name",
    cell: ({ row }) => <span>{row.original.rejectedByFirstName}</span>,
  },
  // {
  //   accessorKey: "status",
  //   header: "Status",
  //   cell: ({ row }) => <span>{row.original.status}</span>,
  // },
  {
    accessorKey: "distance",
    header: "Distance",
    cell: ({ row }) => <span>{row.original.distance}</span>,
  },
  {
    accessorKey: "from",
    header: "From Address",
    cell: ({ row }) => <span>{row.original.from.address}</span>,
  },
  {
    accessorKey: "destination",
    header: "Destination Address",
    cell: ({ row }) => <span>{row.original.destination.address}</span>,
  },
  {
    accessorKey: "estFare",
    header: "Estimated Fare",
    cell: ({ row }) => <span>{row.original.estFare}</span>,
  },
  {
    accessorKey: "createdAt",
    header: "Created At",
    cell: ({ row }) => {
      const createdAtDate = new Date(row.original.createdAt);
      return <span>{createdAtDate.toLocaleString()}</span>;
    },
  },
];
